﻿namespace Code6587EN.Ch05.NewPageWebPart
{
    using Microsoft.SharePoint;
    using Microsoft.SharePoint.Administration;
    using Microsoft.SharePoint.Publishing;
    using Microsoft.SharePoint.WebPartPages;
    using System;
    using System.Linq;
    using System.Web.UI.WebControls.WebParts;
    using System.Xml;

    /// <summary>
    /// Console Application to Create a New a Publishing Page with a Web Part added
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {
            // Open the Site Collection containing the Site
            using (var site = new SPSite("http://sharepoint/publishing"))
            {
                // Open the Site
                using (var web = site.OpenWeb())
                {
                    // Get the Publishing Site from the SharePoint Site
                    var pubWeb = PublishingWeb.GetPublishingWeb(web);

                    // Get the specified Page Layout from the available layouts
                    var layout = pubWeb.GetAvailablePageLayouts().Where(p => p.Title == "Blank Web Part Page").First();

                    // Create the new Page
                    var page = pubWeb.AddPublishingPage("CodePageWithWebPart.aspx", layout);
                    page.Update();

                    // Set the Title of the Page
                    page.ListItem["Title"] = "Code Page With Web Part";
                    page.ListItem.Update();
                    
                    // Get the Web Part Manager for the Page
	                var wpm = web.GetLimitedWebPartManager(page.Url, PersonalizationScope.Shared);

	                // Create a new Content Editor Web Part
	                var cewp = new ContentEditorWebPart();
	                cewp.Title = "Code Web Part Title";
	                cewp.ChromeType = PartChromeType.TitleOnly;
	                var xml = new XmlDocument();
	                xml.LoadXml("<Content>Code Web Part Content</Content>");
	                cewp.Content = xml.FirstChild as XmlElement;

	                // Add the Web Part to the Page
	                wpm.AddWebPart(cewp, "Header", 0);
                }
            }

            // Wait for a key to be pressed before closing the application
            Console.WriteLine("Press Any Key to Continue...");
            Console.Read();
        }
    }
}
